#include "stdafx.h"
#include "CommonFun.h"
//#include "DecCtrlClient.h"
#include "CLS_NVDSDK_Interface.h"

#define LOG_BUF_LENGTH 4096

extern WORD g_wLanguage;
const char g_cLog[4][16] = {"info","debug","warn","error"};  //ֱӦ4ּ

static const char BaseTable[66]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/-"; 

#ifdef _DEBUG
int g_iLogLevel = LOG_LEVEL_DEBUG;
#else
int g_iLogLevel = LOG_LEVEL_WARN;
#endif

int IsValidIP(const char* _cIP)
{
	if (!_cIP)
	{
		fprintf(stderr, "::IsValidIP null param !\n");
		return -1;
	}
	int i = 0;
	int i1 = 0;
	int i2 = 0;
	int i3 = 0;
	int i4 = 0;
	char cOther='\0';

	unsigned long uIP=0;
	if (sscanf_s(_cIP, "%03d.%03d.%03d.%d%c", &i1, &i2, &i3, &i4, &cOther) != 4)
		return 0;
	if ( ((0 <= i1) && (i1 <= 255)) &&
		((0 <= i2) && (i2 <= 255)) &&
		((0 <= i3) && (i3 <= 255)) &&
		((0 <= i4) && (i4 <= 255)) )
	{
		if ((224 <= i1) && (i1 <= 239))
			return 2;   //Multicast

		uIP = (i1<<24) | (i2<<16) | (i3<<8) | (i4);
		i=0;
		while (((uIP & 0x01)==0) && i<32)
		{
			uIP = uIP>>1;
			i++;
		}
		while (((uIP & 0x01)==1) && i<32)
		{
			uIP = uIP>>1;
			i++;
		}
		if (i==32)
			return 3;     //Mask
		else
			return 1;     //valid ip
	}

	return -1;
}

CString GetText(int _iIDS)
{
	CString strBuffer;
	strBuffer.LoadString(AfxGetResourceHandle(),_iIDS,g_wLanguage);
	return strBuffer;
}

void AddLog(int _iLevel, char * _szFmt, ...)
{
	if(_iLevel < g_iLogLevel)
	{
		return;
	}

	va_list vl;
	va_start(vl, _szFmt);
	char logbuf[LOG_BUF_LENGTH] = {0};
	vsprintf_s(logbuf, _szFmt, vl);
	char cMsg[LOG_BUF_LENGTH] = {0};	
	SYSTEMTIME sysTime;
	GetLocalTime(&sysTime);
	sprintf_s(cMsg, sizeof(cMsg), "Decoder %5s: %02d-%02d %02d:%02d:%02d > %s\n", 
		g_cLog[_iLevel],sysTime.wMonth, sysTime.wDay,sysTime.wHour,
		sysTime.wMinute,sysTime.wSecond,logbuf);
	OutputDebugString((LPCTSTR)cMsg);
	va_end(vl);	
}
//---------------------------------------------------------------------------
unsigned char FindInTable(unsigned char c)
{
	int i=0;
	for(i=0;i<65;i++)
	{
		if(BaseTable[i]==c)
		{
			return i;
		}
	}
	return 0;
}

int InsertColumn( CListCtrl& _ListCtrl,int _iColumn,LPCTSTR _strColumn, int _iFormat /*= LVCFMT_LEFT*/,int _iWidth /*= -1*/,int _iSubItem /*= -1*/ )
{
	CHeaderCtrl* pHeader = _ListCtrl.GetHeaderCtrl();
	if (pHeader)
	{
		int iCount = pHeader->GetItemCount();
		if (_iColumn >= 0 && _iColumn < iCount)
		{
			HDITEM hdItem = {0};
			hdItem.mask = HDI_TEXT;
			hdItem.pszText = (LPSTR)_strColumn;
			pHeader->SetItem(_iColumn,&hdItem);
			return 0;
		}
	}

	_ListCtrl.InsertColumn(_iColumn,_strColumn,_iFormat,_iWidth,_iSubItem);
	return 0;
}

int InsertColumn( CListCtrl& _ListCtrl,int _iColumn,unsigned int _uIDResource, int _iFormat /*= LVCFMT_LEFT*/,int _iWidth /*= -1*/,int _iSubItem /*= -1*/ )
{
	return InsertColumn(_ListCtrl,_iColumn,GetTextEx(_uIDResource),_iFormat,_iWidth,_iSubItem);
}

int DecodeBase64(char* Result, char* Source)
{
	unsigned char x1,x2,x3,x4,xt;
	int SrcLen,Times,i,iResult=0;
	memset(Result,0,512);

	SrcLen=strlen(Source);
	Times=SrcLen / 4;
	for(i=0;i<Times;i++)
	{
		x1=FindInTable(Source[0+i*4]);
		x2=FindInTable(Source[1+i*4]);
		x3=FindInTable(Source[2+i*4]);
		x4=FindInTable(Source[3+i*4]);

		x1<<=2;
		xt=x2>>4;
		x1=x1 | xt;
		Result[iResult++]=x1;

		x2<<=4;
		if (x3==64)
		{
			break;
		}
		xt=x3>>2;
		x2=x2 | xt;
		x3<<=6;
		Result[iResult++]=x2;

		if (x4==64)
		{
			break;
		}
		x3=x3 | x4;
		Result[iResult++]=x3;
	}
	return 0;
}
//---------------------------------------------------------------------------
int EncodeBase64(char* Result,char* Source)
{
	int Times,LenSrc,i,iResult=0;
	unsigned char x1,x2,x3,x4,xt,xt1;
	memset(Result,0,512);
	LenSrc=strlen(Source);
	if (LenSrc % 3==0) Times=LenSrc/3;
	else Times=LenSrc/3+1;
	for(i=0;i<Times;i++)
	{
		if (LenSrc>=(3*i+3))
		{
			xt=Source[0+i*3];
			xt>>=2;
			x1=BaseTable[xt];
			xt=Source[0+i*3];
			xt<<=4;
			xt&=48;
			xt1=Source[1+i*3];
			xt1>>=4;
			xt|=xt1;
			x2=BaseTable[xt];
			xt=Source[1+i*3];
			xt<<=2;
			xt&=60;
			xt1=Source[2+i*3];
			xt1>>=6;
			xt|=xt1;
			x3=BaseTable[xt];
			xt=Source[2+i*3] ;
			xt&=63;
			x4=BaseTable[xt];
		}
		else if (LenSrc>=3*i+2)
		{
			xt=Source[0+i*3];
			xt>>=2;
			x1=BaseTable[xt];
			xt=Source[0+i*3];
			xt<<=4;
			xt&=48;
			xt1=Source[1+i*3];
			xt1>>=4;
			xt|=xt1;
			x2=BaseTable[xt];
			xt=Source[1+i*3];
			xt<<=2;
			xt&= 60;
			x3=BaseTable[xt];
			x4='=';
		}
		else
		{
			xt=Source[0+i*3];
			xt>>=2;
			x1=BaseTable[xt];
			xt=Source[0+i*3] ;
			xt<<=4;
			xt&=48;
			x2=BaseTable[xt];
			x3='=';
			x4='=';
		}

		Result[iResult++]=(char)(x1);
		Result[iResult++]=(char)(x2);
		Result[iResult++]=(char)(x3);
		Result[iResult++]=(char)(x4);
	}
	return 0;
}

CString IntToStr( int _iValue )
{
	char pcValue[32] = {0};
	sprintf_s(pcValue,"%d",_iValue);
	CString strTemp = pcValue;
	return strTemp;
}

int InsertString( CComboBox& _ComboBox,int _iIndex,unsigned int _uIDResource )
{
	return InsertString(_ComboBox,_iIndex,GetTextEx(_uIDResource));
}

int InsertString( CComboBox& _ComboBox,int _iIndex,LPCTSTR _strItem )
{
	int iItem = _ComboBox.GetCurSel();
	_ComboBox.DeleteString(_iIndex);
	_ComboBox.InsertString(_iIndex,_strItem);
	_ComboBox.SetCurSel(iItem);

	return 0;
}

int CheckChannel(int iLogonId, bool* blUsedChannel, int* iChannelNum, bool* blUsedScreen, int* iScreenNum, int iCurrentChannel)
{
	*iChannelNum = 0;
	*iScreenNum = 0; 
	tDevInfo tDecoderInfo = {0};//ȡ tDecoderInfo.iSplitChanNum
	tDecoderInfo.iSize = sizeof(tDevInfo);
	int iRet = DEC_ClientGetDevConfig(iLogonId, 0, 0, CMD_DEC_CFG_DEV_INFO, &tDecoderInfo, sizeof(tDevInfo));
	//*iChannelNum = tDecoderInfo.iSplitChanNum;
	BaseOffset tGetStartAddress = {0}; //ȡƫ
	iRet = DEC_ClientGetDevConfig(iLogonId, 0, 0, CMD_DEC_CFG_BASE_OFFSET, &tGetStartAddress, sizeof(BaseOffset));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
		return -1;
	}

	for (int j = 0; j < tDecoderInfo.iSplitChanNum; j++)//ѭȡÿļͨɵ
	{
		if(j == iCurrentChannel){
			continue;
		}
		CreateVVOInfo strCreateVVOInfo = {0};
		strCreateVVOInfo.iBufSize = sizeof(CreateVVOInfo);
		strCreateVVOInfo.iVVOChannelNo = j + tGetStartAddress.iSplitScreen;//ͨ strCreateVVOInfo.iInputChannel дţ24,5ͨɣiInputChannel[0] = 2,iInputChannel[1] = 4,iInputChannel[2] = 5
		iRet = DEC_ClientGetDevConfig(iLogonId, strCreateVVOInfo.iVVOChannelNo, 0, CMD_DEC_CFG_CREATE_VVO, &strCreateVVOInfo, sizeof(CreateVVOInfo));
		if(iRet < 0)
		{
			AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
			return -1;
		}
		int iUsedNum = strCreateVVOInfo.iCols * strCreateVVOInfo.iRows;//ɲΪͨɣζŸôͨ
		if (iUsedNum > 0)
		{
			blUsedScreen[j] = true;//ɲΪͨɣζŸôͨڣ±Ǽƫ֮ǰģ
		}
		for (int i = 0; i<iUsedNum; i++)
		{
			int iChannelNO = strCreateVVOInfo.iInputChannel[i];
			if(0 <= iChannelNO && iChannelNO < DEC_MAX_PHYSICAL_CHANNEL_NUM){
				if(blUsedChannel[iChannelNO] == false){
					(*iChannelNum)++;
				}
				blUsedChannel[iChannelNO] = true;
			}
		}
	}
	return 0;
}


int CreateChannelCombo(int iLogonId, CComboBox* pChannelCobox)
{
	bool blUsedChannel[DEC_MAX_PHYSICAL_CHANNEL_NUM] = {false};
	bool blUsedScreen[DEC_MAX_SPLIT_CHANNEL_NUM] = {false};
	int iUsedScreen = 0;
	int iUsedChannel = 0;
	int iRet = CheckChannel(iLogonId, blUsedChannel, &iUsedChannel, blUsedScreen, &iUsedScreen, -1);
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
		return -1;
	}
	BaseOffset tGetStartAddress;//ȡƫ
	iRet = DEC_ClientGetDevConfig(iLogonId, 0, 0, CMD_DEC_CFG_BASE_OFFSET, &tGetStartAddress, sizeof(BaseOffset));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
		return -1;
	}

	CString strChanel;
	tDevInfo tDevInfomation = {0};
	iRet = DEC_ClientGetDevConfig(iLogonId, 0, 0, CMD_DEC_CFG_DEV_INFO, &tDevInfomation, sizeof(tDevInfo));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
		return -1;
	}

	int iIndexSysChannel = 0;
	for (int i=0; i<tDevInfomation.iChanNum; ++i)
	{
		if (!blUsedChannel[i])
		{
			strChanel.Format(_T("%s%d"),GetText(IDS_MAIN_CHANNEL),i + 1);
			iIndexSysChannel = pChannelCobox->AddString(strChanel);
			pChannelCobox->SetItemData(iIndexSysChannel, i);
		}
	}

	//ƴͨ
	for (int i=0; i<DEC_MAX_SPLIT_CHANNEL_NUM; i++)
	{
		if (blUsedScreen[i])
		{
			strChanel.Format(_T("%s%d"),GetText(IDS_SETTING_MULI_SCREEN_TITLE), i + 1);
			iIndexSysChannel = pChannelCobox->AddString(strChanel);
			pChannelCobox->SetItemData(iIndexSysChannel, i + tGetStartAddress.iSplitScreen);
		}
	}

	pChannelCobox->SetCurSel(0);
	return 0;
}




int CreatePosCombo(int iLogonId, int iChannelNo, int iPos, CComboBox* pPosCobox, int iType)//typeʾӿѡ
{
	pPosCobox->ResetContent();


	int iMode = 0;
	ChannelPicNum tPicNum = {0};
	tPicNum.iSize = sizeof(ChannelPicNum);
	//ȡͨ
	int iRet = DEC_ClientGetDevConfig(iLogonId ,iChannelNo, 0, CMD_DEC_CFG_PICNUM, &tPicNum, sizeof(ChannelPicNum));
	if (ERR_SUCCESS == iRet)
	{
		iMode = tPicNum.iPicNum;
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR, "DEC_ClientGetDevConfig Failed! Ret(%d),CMDID(%d)",iRet, CMD_DEC_CFG_PICNUM);
		return -1;
	}
	CString strPos;
	//ȡƫ
	BaseOffset tGetStartAddress;
	iRet = DEC_ClientGetDevConfig(iLogonId, 0, 0, CMD_DEC_CFG_BASE_OFFSET, 
		&tGetStartAddress, sizeof(BaseOffset));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_ERROR, "DEC_ClientGetDevConfig Failed! Ret(%d),CMDID(%d)",iRet, CMD_DEC_CFG_PICNUM);
		return -1;
	}
	//ͨ
	int iIndexSysPos = 0;
	if(iMode != 0)
	{
		for (int i = 0; i < iMode; ++i)
		{
			strPos.Format(_T("%s%d"),GetText(IDS_MAIN_SCREEN),i + 1);
			iIndexSysPos = pPosCobox->AddString(strPos);
			pPosCobox->SetItemData(iIndexSysPos,i);
		}
	}
	//ͨ
	if(iType == 1)
	{
		iRet = -1;
		FloatWindow tWindowInfo = {0};
		for(int i = 0;i < DEC_MAX_FLOAT_WINDOW_NUM;i++)
		{
			iRet = DEC_ClientGetDevConfig(iLogonId, iChannelNo, i + tGetStartAddress.iFloatWindow, CMD_DEC_CFG_FLOAT_WINDOW, &tWindowInfo, sizeof(FloatWindow));
			if(iRet == -1)
			{
				AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::Connect] Looping!ID(%d),Channel(%d),Pos(%d)",iLogonId, iChannelNo,i + tGetStartAddress.iFloatWindow);
			}
			if(tWindowInfo.iEnable == 1)
			{
				strPos.Format(_T("%s%d"),GetText(IDS_POPUP_SCREEN),i + 1);
				iIndexSysPos = pPosCobox->AddString(strPos);
				pPosCobox->SetItemData(iIndexSysPos,i + tGetStartAddress.iFloatWindow);
			}
		}
	}

	int iCount = pPosCobox->GetCount();
	if (iPos < 0 || iPos >= iCount)
	{
		iPos = 0;
	}
	pPosCobox->SetCurSel(iPos);

	return 0;
}

int ConvertItem(ServerItem& uItem, TNVSITEMEX* _pPara)
{
	memset(&uItem, 0, sizeof(ServerItem));
	if (_pPara->m_iDevPlatType == DEVTYPE_NORMAL) 
	{  
		uItem.tNormal.iSize = sizeof(NormalServer);
		strncpy(uItem.tNormal.cServerName, _pPara->m_stOldItem.m_serName,sizeof(uItem.tNormal.cServerName) - 1);
		strncpy(uItem.tNormal.tCommonInfo.cServerIp, _pPara->m_stOldItem.m_serIP,sizeof(uItem.tNormal.tCommonInfo.cServerIp) - 1);
		strncpy(uItem.tNormal.cServerProxy, _pPara->m_stOldItem.m_serProxy,sizeof(uItem.tNormal.cServerProxy) - 1);
		uItem.tNormal.tCommonInfo.iServerPort = _pPara->m_stOldItem.m_serPort;
		uItem.tNormal.tCommonInfo.iServerChannelNo = _pPara->m_stOldItem.m_serChan;
		uItem.tNormal.tCommonInfo.iServerStreamNo = _pPara->m_stOldItem.m_serStream;
		uItem.tNormal.tCommonInfo.iServerNetmode = _pPara->m_stOldItem.m_serNetmode;		
		uItem.tNormal.iConnectMode = _pPara->m_stOldItem.m_bUseddns;	
		uItem.tNormal.tCommonInfo.iHoldTime = _pPara->m_stOldItem.m_holdtime;
		strncpy(uItem.tNormal.tCommonInfo.cServerUserName, _pPara->m_stOldItem.m_username,sizeof(uItem.tNormal.tCommonInfo.cServerUserName) - 1);
		strncpy(uItem.tNormal.tCommonInfo.cServerPassword, _pPara->m_stOldItem.m_password,sizeof(uItem.tNormal.tCommonInfo.cServerPassword) - 1);
		strncpy(uItem.tNormal.tCommonInfo.cServerPtzProtocol, _pPara->m_stOldItem.m_deviceType,sizeof(uItem.tNormal.tCommonInfo.cServerPtzProtocol) - 1);
		uItem.tNormal.tCommonInfo.iServerPtzAddress = _pPara->m_stOldItem.m_iAddress;
		strncpy(uItem.tNormal.cVideoDecryptPassword, _pPara->m_cEncyptPWD,sizeof(uItem.tNormal.cVideoDecryptPassword) - 1);
	}
	else if (DEVTYPE_ONVIF == _pPara->m_iDevPlatType || DEVTYPE_LG == _pPara->m_iDevPlatType || DEVTYPE_PANASONIC == _pPara->m_iDevPlatType) 
	{
		uItem.tOnvif.iSize = sizeof(OnvifServer);
		strncpy(uItem.tOnvif.tCommonInfo.cServerIp, _pPara->m_stOldItem.m_serIP,sizeof(uItem.tOnvif.tCommonInfo.cServerIp) - 1);
		uItem.tOnvif.tCommonInfo.iServerPort = _pPara->m_stOldItem.m_serPort;
		uItem.tOnvif.tCommonInfo.iServerChannelNo = _pPara->m_stOldItem.m_serChan;
		uItem.tOnvif.tCommonInfo.iServerStreamNo = _pPara->m_stOldItem.m_serStream;
		uItem.tOnvif.tCommonInfo.iServerNetmode = _pPara->m_stOldItem.m_serNetmode;			
		uItem.tOnvif.tCommonInfo.iHoldTime = _pPara->m_stOldItem.m_holdtime;
		strncpy(uItem.tOnvif.tCommonInfo.cServerUserName, _pPara->m_stOldItem.m_username,sizeof(uItem.tOnvif.tCommonInfo.cServerUserName) - 1);
		strncpy(uItem.tOnvif.tCommonInfo.cServerPassword, _pPara->m_stOldItem.m_password,sizeof(uItem.tOnvif.tCommonInfo.cServerPassword) - 1);
		strncpy(uItem.tOnvif.tCommonInfo.cServerPtzProtocol, _pPara->m_stOldItem.m_deviceType,sizeof(uItem.tOnvif.tCommonInfo.cServerPtzProtocol) - 1);
		uItem.tOnvif.tCommonInfo.iServerPtzAddress = _pPara->m_stOldItem.m_iAddress;

	}
	else if (_pPara->m_iDevPlatType == DEVTYPE_RTSP) 
	{
		uItem.tRtsp.iSize = sizeof(RtspServer);
		strncpy(uItem.tRtsp.cRtspUrl, _pPara->m_stOldItem.m_cRTSPUrl,sizeof(uItem.tRtsp.cRtspUrl) - 1);
		strncpy(uItem.tRtsp.tCommonInfo.cServerIp, _pPara->m_stOldItem.m_serIP,sizeof(uItem.tRtsp.tCommonInfo.cServerIp) - 1);
		uItem.tRtsp.tCommonInfo.iServerPort = _pPara->m_stOldItem.m_serPort;
		uItem.tRtsp.tCommonInfo.iServerChannelNo = _pPara->m_stOldItem.m_serChan;
		uItem.tRtsp.tCommonInfo.iServerStreamNo = _pPara->m_stOldItem.m_serStream;
		uItem.tRtsp.tCommonInfo.iServerNetmode = _pPara->m_stOldItem.m_serNetmode;			
		uItem.tRtsp.tCommonInfo.iHoldTime = _pPara->m_stOldItem.m_holdtime;
		strncpy(uItem.tRtsp.tCommonInfo.cServerUserName, _pPara->m_stOldItem.m_username,sizeof(uItem.tRtsp.tCommonInfo.cServerUserName) - 1);
		strncpy(uItem.tRtsp.tCommonInfo.cServerPassword, _pPara->m_stOldItem.m_password,sizeof(uItem.tRtsp.tCommonInfo.cServerPassword) - 1);
		strncpy(uItem.tRtsp.tCommonInfo.cServerPtzProtocol, _pPara->m_stOldItem.m_deviceType,sizeof(uItem.tRtsp.tCommonInfo.cServerPtzProtocol) - 1);
		uItem.tRtsp.tCommonInfo.iServerPtzAddress = _pPara->m_stOldItem.m_iAddress;
		strncpy(uItem.tRtsp.cMultIP, _pPara->m_cMultIP,sizeof(uItem.tRtsp.cMultIP) - 1);
		uItem.tRtsp.iMultPort = _pPara->m_iMultPort;

	}
	else if (_pPara->m_iDevPlatType == DEVTYPE_ENCODE||DEVTYPE_LOCAL == _pPara->m_iDevPlatType)
	{
		uItem.tEncode.iSize = sizeof(EncodeChannel);
		strncpy(uItem.tEncode.tCommonInfo.cServerIp, _pPara->m_stOldItem.m_serIP,sizeof(uItem.tEncode.tCommonInfo.cServerIp) - 1);
		uItem.tEncode.tCommonInfo.iServerPort = _pPara->m_stOldItem.m_serPort;
		uItem.tEncode.tCommonInfo.iServerChannelNo = _pPara->m_stOldItem.m_serChan;
		uItem.tEncode.tCommonInfo.iServerStreamNo = _pPara->m_stOldItem.m_serStream;
		uItem.tEncode.tCommonInfo.iServerNetmode = _pPara->m_stOldItem.m_serNetmode;			
		uItem.tEncode.tCommonInfo.iHoldTime = _pPara->m_stOldItem.m_holdtime;
		strncpy(uItem.tEncode.tCommonInfo.cServerUserName, _pPara->m_stOldItem.m_username,sizeof(uItem.tEncode.tCommonInfo.cServerUserName) - 1);
		strncpy(uItem.tEncode.tCommonInfo.cServerPassword, _pPara->m_stOldItem.m_password,sizeof(uItem.tEncode.tCommonInfo.cServerPassword) - 1);
		strncpy(uItem.tEncode.tCommonInfo.cServerPtzProtocol, _pPara->m_stOldItem.m_deviceType,sizeof(uItem.tEncode.tCommonInfo.cServerPtzProtocol) - 1);
		uItem.tEncode.tCommonInfo.iServerPtzAddress = _pPara->m_stOldItem.m_iAddress;
	}
	else
	{
		
	}

	return 0;
}

int ConvertItemEx( ServerItem* _puItem, int _iServerType, ViewServerInfo& tServer)
{
	memset(&tServer, 0, sizeof(ViewServerInfo));

	tServer.ser_type = _iServerType;

	if (_iServerType == DEVTYPE_NORMAL) 
	{
		NormalServer tNormal = {0};
		int iCpySize = _puItem->tNormal.iSize;
		if (iCpySize <= 0 || iCpySize > sizeof(NormalServer)) {
			iCpySize = sizeof(NormalServer);
		}
		memcpy(&tNormal, &_puItem->tNormal, iCpySize);

		strncpy(tServer.ser_name, tNormal.cServerName,sizeof(tServer.ser_name) - 1);
		strncpy(tServer.ser_ip, tNormal.tCommonInfo.cServerIp,sizeof(tServer.ser_ip) - 1);
		strncpy(tServer.ser_proxy, tNormal.cServerProxy,sizeof(tServer.ser_proxy) - 1);
		tServer.ser_port = tNormal.tCommonInfo.iServerPort;
		tServer.ser_ch_no = tNormal.tCommonInfo.iServerChannelNo;
		tServer.ser_stream_no = tNormal.tCommonInfo.iServerStreamNo;
		tServer.ser_net_mode = tNormal.tCommonInfo.iServerNetmode;
		tServer.con_mode = tNormal.iConnectMode;	
		tServer.hold_time = tNormal.tCommonInfo.iHoldTime;
		strncpy(tServer.ser_usr_name, tNormal.tCommonInfo.cServerUserName,sizeof(tServer.ser_usr_name) - 1);
		strncpy(tServer.ser_usr_pwd, tNormal.tCommonInfo.cServerPassword,sizeof(tServer.ser_usr_pwd) - 1);
		strncpy(tServer.ser_ptz_protocol, tNormal.tCommonInfo.cServerPtzProtocol,sizeof(tServer.ser_ptz_protocol) - 1);
		tServer.ser_ptz_addr = tNormal.tCommonInfo.iServerPtzAddress;
		strncpy(tServer.video_dec_pwd, tNormal.cVideoDecryptPassword,sizeof(tServer.video_dec_pwd) - 1);
	}
	else if (DEVTYPE_ONVIF == _iServerType || DEVTYPE_LG == _iServerType || DEVTYPE_PANASONIC == _iServerType)
	{
		OnvifServer tOnvif = {0};
		int iCpySize = _puItem->tOnvif.iSize;
		if (iCpySize <= 0 || iCpySize > sizeof(OnvifServer)) {
			iCpySize = sizeof(OnvifServer);
		}
		memcpy(&tOnvif, &_puItem->tOnvif, iCpySize);

		strncpy(tServer.ser_ip, tOnvif.tCommonInfo.cServerIp,sizeof(tServer.ser_ip) - 1);
		tServer.ser_port = tOnvif.tCommonInfo.iServerPort;
		tServer.ser_ch_no = tOnvif.tCommonInfo.iServerChannelNo;
		tServer.ser_stream_no = tOnvif.tCommonInfo.iServerStreamNo;
		tServer.ser_net_mode = tOnvif.tCommonInfo.iServerNetmode;	
		tServer.hold_time = tOnvif.tCommonInfo.iHoldTime;
		strncpy(tServer.ser_usr_name, tOnvif.tCommonInfo.cServerUserName,sizeof(tServer.ser_usr_name) - 1);
		strncpy(tServer.ser_usr_pwd, tOnvif.tCommonInfo.cServerPassword,sizeof(tServer.ser_usr_pwd) - 1);
		strncpy(tServer.ser_ptz_protocol, tOnvif.tCommonInfo.cServerPtzProtocol,sizeof(tServer.ser_ptz_protocol) - 1);
		tServer.ser_ptz_addr = tOnvif.tCommonInfo.iServerPtzAddress;
	}
	else if (_iServerType == DEVTYPE_RTSP)
	{
		RtspServer tRtsp = {0};
		int iCpySize = _puItem->tOnvif.iSize;
		if (iCpySize <= 0 || iCpySize > sizeof(RtspServer)) {
			iCpySize = sizeof(RtspServer);
		}
		memcpy(&tRtsp, &_puItem->tRtsp, iCpySize);

		if (0 != strcmp(tRtsp.cRtspUrl, "")) {
			char* pcUrl = (char*)(tRtsp.cRtspUrl);		//RTSPַ
			strncpy(tServer.ser_name, pcUrl, DEC_LEN_128 - 1);
			strncpy(tServer.ser_ip, pcUrl + DEC_LEN_128 - 1, DEC_LEN_32 - 1);
			strncpy(tServer.ser_proxy, pcUrl + DEC_LEN_128 + DEC_LEN_32 - 2, DEC_LEN_32 - 1);
		} else {
			strncpy(tServer.ser_ip, tRtsp.tCommonInfo.cServerIp,sizeof(tServer.ser_ip) - 1);
		}

		tServer.ser_port = tRtsp.tCommonInfo.iServerPort;
		tServer.ser_ch_no = tRtsp.tCommonInfo.iServerChannelNo;
		tServer.ser_stream_no = tRtsp.tCommonInfo.iServerStreamNo;
		tServer.ser_net_mode = tRtsp.tCommonInfo.iServerNetmode;	//0:TCP, 1:UDP, 2:MUT
		tServer.hold_time = tRtsp.tCommonInfo.iHoldTime;
		strncpy(tServer.ser_usr_name, tRtsp.tCommonInfo.cServerUserName,sizeof(tServer.ser_usr_name) - 1);
		strncpy(tServer.ser_usr_pwd, tRtsp.tCommonInfo.cServerPassword,sizeof(tServer.ser_usr_pwd) - 1);
		strncpy(tServer.ser_ptz_protocol, tRtsp.tCommonInfo.cServerPtzProtocol,sizeof(tServer.ser_ptz_protocol) - 1);
		tServer.ser_ptz_addr = tRtsp.tCommonInfo.iServerPtzAddress;
		strncpy(tServer.mult_ip, tRtsp.cMultIP,sizeof(tServer.mult_ip) - 1);
		tServer.mult_port = tRtsp.iMultPort;
		strncpy(tServer.rtsp_url, tRtsp.cRtspUrl, DEC_LEN_256 + 1);
	}
	else if (_iServerType == DEVTYPE_ENCODE || DEVTYPE_LOCAL == _iServerType)
	{
		EncodeChannel tEncodeChannel = {0};
		int iCpySize = _puItem->tEncode.iSize;
		if (iCpySize <= 0 || iCpySize > sizeof(EncodeChannel)) {
			iCpySize = sizeof(EncodeChannel);
		}
		memcpy(&tEncodeChannel, &_puItem->tEncode, iCpySize);

		strncpy(tServer.ser_ip, tEncodeChannel.tCommonInfo.cServerIp,sizeof(tServer.ser_ip) - 1);
		tServer.ser_port = tEncodeChannel.tCommonInfo.iServerPort;
		tServer.ser_ch_no = tEncodeChannel.tCommonInfo.iServerChannelNo;
		tServer.ser_stream_no = tEncodeChannel.tCommonInfo.iServerStreamNo;
		tServer.ser_net_mode = tEncodeChannel.tCommonInfo.iServerNetmode;	
		tServer.hold_time = tEncodeChannel.tCommonInfo.iHoldTime;
		strncpy(tServer.ser_usr_name, tEncodeChannel.tCommonInfo.cServerUserName,sizeof(tServer.ser_usr_name) - 1);
		strncpy(tServer.ser_usr_pwd, tEncodeChannel.tCommonInfo.cServerPassword,sizeof(tServer.ser_usr_pwd) - 1);
		strncpy(tServer.ser_ptz_protocol, tEncodeChannel.tCommonInfo.cServerPtzProtocol,sizeof(tServer.ser_ptz_protocol) - 1);
		tServer.ser_ptz_addr = tEncodeChannel.tCommonInfo.iServerPtzAddress;
	}
	else
	{
		//log_msg_ex("inalid server type!");
		return ERR_UNDEFINED_BEHAVIOR;
	}

	return 0;
}

int ConvertSeverToItem(IN ViewServerInfo* _ptServer, OUT ServerItem* _puItem, OUT int* _piServerType)
{
	if (NULL == _ptServer || NULL == _puItem || NULL == _piServerType)
	{
		return ERR_NULL_PTR;
	}

	memset(_puItem, 0, sizeof(ServerItem));

	int iServerType = _ptServer->ser_type;
	*_piServerType = iServerType;
	if (DEVTYPE_NORMAL == iServerType) 
	{
		_puItem->tNormal.iSize = sizeof(NormalServer);
		strncpy(_puItem->tNormal.tCommonInfo.cServerIp, _ptServer->ser_ip, sizeof(_puItem->tNormal.tCommonInfo.cServerIp));
		_puItem->tNormal.tCommonInfo.iServerPort = _ptServer->ser_port;
		_puItem->tNormal.tCommonInfo.iServerChannelNo = _ptServer->ser_ch_no;
		_puItem->tNormal.tCommonInfo.iServerStreamNo  = _ptServer->ser_stream_no;
		_puItem->tNormal.tCommonInfo.iServerNetmode = _ptServer->ser_net_mode;
		_puItem->tNormal.tCommonInfo.iHoldTime = _ptServer->hold_time;
		strncpy(_puItem->tNormal.tCommonInfo.cServerUserName, _ptServer->ser_usr_name, sizeof(_puItem->tNormal.tCommonInfo.cServerUserName));
		strncpy(_puItem->tNormal.tCommonInfo.cServerPassword, _ptServer->ser_usr_pwd, sizeof(_puItem->tNormal.tCommonInfo.cServerPassword));
		strncpy(_puItem->tNormal.tCommonInfo.cServerPtzProtocol, _ptServer->ser_ptz_protocol, sizeof(_puItem->tNormal.tCommonInfo.cServerPtzProtocol));
		_puItem->tNormal.tCommonInfo.iServerPtzAddress = _ptServer->ser_ptz_addr;
		_puItem->tNormal.iConnectMode = _ptServer->con_mode;
		strncpy(_puItem->tNormal.cServerName, _ptServer->ser_name, sizeof(_puItem->tNormal.cServerName));
		strncpy(_puItem->tNormal.cServerProxy, _ptServer->ser_proxy, sizeof(_puItem->tNormal.cServerProxy));
		strncpy(_puItem->tNormal.cVideoDecryptPassword, _ptServer->video_dec_pwd, sizeof(_puItem->tNormal.cVideoDecryptPassword));
	} 
	else if (DEVTYPE_ONVIF == iServerType || DEVTYPE_LG == iServerType || DEVTYPE_PANASONIC == iServerType) 
	{
		_puItem->tOnvif.iSize = sizeof(OnvifServer);
		strncpy(_puItem->tOnvif.tCommonInfo.cServerIp, _ptServer->ser_ip, DEC_LEN_32);
		_puItem->tOnvif.tCommonInfo.iServerPort = _ptServer->ser_port;
		_puItem->tOnvif.tCommonInfo.iServerChannelNo = _ptServer->ser_ch_no;
		_puItem->tOnvif.tCommonInfo.iServerStreamNo  = _ptServer->ser_stream_no;
		_puItem->tOnvif.tCommonInfo.iServerNetmode = _ptServer->ser_net_mode;
		_puItem->tOnvif.tCommonInfo.iHoldTime = _ptServer->hold_time;
		strncpy(_puItem->tOnvif.tCommonInfo.cServerUserName, _ptServer->ser_usr_name, DEC_LEN_64);
		strncpy(_puItem->tOnvif.tCommonInfo.cServerPassword, _ptServer->ser_usr_pwd, DEC_LEN_64);
		strncpy(_puItem->tOnvif.tCommonInfo.cServerPtzProtocol, _ptServer->ser_ptz_protocol, DEC_LEN_32);
		_puItem->tOnvif.tCommonInfo.iServerPtzAddress = _ptServer->ser_ptz_addr;
	} 
	else if (DEVTYPE_RTSP == iServerType)
	{
		_puItem->tRtsp.iSize = sizeof(RtspServer);
		strncpy(_puItem->tRtsp.tCommonInfo.cServerIp, _ptServer->ser_ip, DEC_LEN_32);
		_puItem->tRtsp.tCommonInfo.iServerPort = _ptServer->ser_port;
		_puItem->tRtsp.tCommonInfo.iServerChannelNo = _ptServer->ser_ch_no;
		_puItem->tRtsp.tCommonInfo.iServerStreamNo  = _ptServer->ser_stream_no;
		_puItem->tRtsp.tCommonInfo.iServerNetmode = _ptServer->ser_net_mode;
		_puItem->tRtsp.tCommonInfo.iHoldTime = _ptServer->hold_time;
		strncpy(_puItem->tRtsp.tCommonInfo.cServerUserName, _ptServer->ser_usr_name, DEC_LEN_64);
		strncpy(_puItem->tRtsp.tCommonInfo.cServerPassword, _ptServer->ser_usr_pwd, DEC_LEN_64);
		strncpy(_puItem->tRtsp.tCommonInfo.cServerPtzProtocol, _ptServer->ser_ptz_protocol, DEC_LEN_32);
		_puItem->tRtsp.tCommonInfo.iServerPtzAddress = _ptServer->ser_ptz_addr;
		strncpy(_puItem->tRtsp.cRtspUrl, _ptServer->rtsp_url, DEC_LEN_256);
		strncpy(_puItem->tRtsp.cMultIP, _ptServer->mult_ip, DEC_LEN_32);
		_puItem->tRtsp.iMultPort = _ptServer->mult_port;
	}
	else if (DEVTYPE_ENCODE == iServerType||DEVTYPE_LOCAL == iServerType)
	{
		_puItem->tEncode.iSize = sizeof(EncodeChannel);
		strncpy(_puItem->tEncode.tCommonInfo.cServerIp, _ptServer->ser_ip, DEC_LEN_32);
		_puItem->tEncode.tCommonInfo.iServerPort = _ptServer->ser_port;
		_puItem->tEncode.tCommonInfo.iServerChannelNo = _ptServer->ser_ch_no;
		_puItem->tEncode.tCommonInfo.iServerStreamNo  = _ptServer->ser_stream_no;
		_puItem->tEncode.tCommonInfo.iServerNetmode = _ptServer->ser_net_mode;
		_puItem->tEncode.tCommonInfo.iHoldTime = _ptServer->hold_time;
		strncpy(_puItem->tEncode.tCommonInfo.cServerUserName, _ptServer->ser_usr_name, DEC_LEN_64);
		strncpy(_puItem->tEncode.tCommonInfo.cServerPassword, _ptServer->ser_usr_pwd, DEC_LEN_64);
		strncpy(_puItem->tEncode.tCommonInfo.cServerPtzProtocol, _ptServer->ser_ptz_protocol, DEC_LEN_32);
		_puItem->tEncode.tCommonInfo.iServerPtzAddress = _ptServer->ser_ptz_addr;
	}
	else
	{
		//log_msg_ex("inalid server type!");
		return ERR_UNDEFINED_BEHAVIOR;
	}

	return 0;
}

int ConvertChannel( int _iLogonID, int _iChannelNo )
{
	BaseOffset tGetStartAddress = {0}; //ȡƫ
	int iRet = DEC_ClientGetDevConfig(_iLogonID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, &tGetStartAddress, sizeof(BaseOffset));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
		return -1;
	}

	if (_iChannelNo < 0){
		//log_msg_ex("CalChanNo channel error %d", channel_no);
		return -1;
	}

	int iChan = _iChannelNo;
	if (iChan >= tGetStartAddress.iSplitScreen){
		iChan -= tGetStartAddress.iSplitScreen;
		iChan += DEC_MAX_PHYSICAL_CHANNEL_NUM;
	}

	if (iChan >= DEC_MAX_CHANNEL_TOTAL_NUM){
		//log_msg_ex("iChan >= DEC_MAX_CHANNEL_TOTAL_NUM");
		return -1;
	}
	
	return iChan;
}

int ConvertPos( int _iLogonID, int iPoslNo )
{
	BaseOffset tGetStartAddress = {0}; //ȡƫ
	int iRet = DEC_ClientGetDevConfig(_iLogonID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, &tGetStartAddress, sizeof(BaseOffset));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
		return -1;
	}

	if (iPoslNo < 0){
		//log_msg_ex("CalChanNo channel error %d", channel_no);
		return -1;
	}

	int iWin = iPoslNo;
	if (iWin >= tGetStartAddress.iFloatWindow){
		iWin -= tGetStartAddress.iFloatWindow;
		iWin += DEC_MAX_PICTURE_NUM;
	}

	if (iWin >= DEC_MAX_WINDOW_TOTAL_NUM){
		//log_msg_ex("iChan >= DEC_MAX_CHANNEL_TOTAL_NUM");
		return -1;
	}

	return iWin;
}

HTREEITEM InsertItem( CTreeCtrl& _TreeCtrl,LPCTSTR _strItem,DWORD_PTR _dwData,HTREEITEM _hParent /*= TVI_ROOT*/ )
{
	DWORD_PTR dwData = 0;
	HTREEITEM hItem = _TreeCtrl.GetChildItem(_hParent);
	while(hItem)
	{
		dwData = _TreeCtrl.GetItemData(hItem);
		if (dwData == _dwData)
		{
			_TreeCtrl.SetItemText(hItem,_strItem);
			return hItem;
		}
		hItem = _TreeCtrl.GetNextSiblingItem(hItem);
	}

	hItem = _TreeCtrl.InsertItem(_strItem,_hParent);
	_TreeCtrl.SetItemData(hItem,_dwData);
	return hItem;
}

HTREEITEM InsertItem( CTreeCtrl& _TreeCtrl,unsigned int _uIDResource,DWORD_PTR _dwData,HTREEITEM _hParent /*= TVI_ROOT*/ )
{
	return InsertItem(_TreeCtrl,GetText(_uIDResource),_dwData,_hParent);
}

int GetComboData(CComboBox* pCobox)
{
	return pCobox->GetItemData(pCobox->GetCurSel());
}


int SplitStringToArray(const string &_strStingSource, const string &_strSplitChar,
    string *_strArray,  int _iArraySize, const int _numberOfElements)
/*  _astrStingSource:Դַ
          _astrSplitCharַָ "/""@"ȣ
          _astrArray    ֵַ飬ֳֵַ
    ܣŸֳַ
*/
{
    int iTempCount=0;
    int iTempPos=0;  //ַָ    //modify by lpy;
    int iTempPos1=0; //¼һַ׵ַ
    int iTempPos2=0; //¼һַβַ

	int iTempStrLen = (int)_strStingSource.length();
    
    if (iTempStrLen > _numberOfElements) //wxl 2011-12-21 ֹڴԽ
    {
        iTempStrLen = _numberOfElements;
    }
    while (iTempPos<=iTempStrLen && (iTempCount < _iArraySize -1))
    {
		string strTemp = _strStingSource.substr(iTempPos,1) ; 
        if (strTemp.compare(_strSplitChar) == 0)
        {
            if (iTempPos1==0)
            {
                iTempPos1=iTempPos+1;
                if(iTempPos != 0)
                {
                    _strArray[iTempCount]=_strStingSource.substr(0, iTempPos);
                    iTempCount++;
                }
            }
            else if (iTempPos2==0)
            {
                iTempPos2=iTempPos+1;
                _strArray[iTempCount]=_strStingSource.substr(iTempPos1,iTempPos2-iTempPos1-1);
                iTempCount++;
                iTempPos1=iTempPos2;
                iTempPos2=0;
            }
        }
        iTempPos++;
    }
		_strArray[iTempCount]=_strStingSource.substr(iTempPos1,iTempPos-iTempPos1);
    return iTempCount+1;
}
#define MAX_LOG_MSG_LEN		4096
const DWORD g_dwLanChinese = 2052;
const DWORD g_dwLanEnglish = 1033;
CString GetTextByLan( CString _cstrTextCH, CString _cstrTextEn/* = ""*/ )
{
	if (g_dwLanChinese == g_wLanguage)
	{
		return _cstrTextCH;
	}
	return _cstrTextEn;
}

CString GetFormatTextByLan( CString _cstrFormatTextCH, CString _cstrFormatTextEn, ... )
{
	CString cstrDstInfo;

	char cLogFmt[MAX_LOG_MSG_LEN] = {0};
	char cLogBuf[MAX_LOG_MSG_LEN] = {0};
	if (g_dwLanChinese == g_wLanguage)
	{
		strncpy_s(cLogFmt, _cstrFormatTextCH.GetBuffer(), min(MAX_LOG_MSG_LEN, _cstrFormatTextCH.GetLength()));
		_cstrFormatTextCH.ReleaseBuffer();
	}
	else
	{
		strncpy_s(cLogFmt, _cstrFormatTextEn.GetBuffer(), min(MAX_LOG_MSG_LEN, _cstrFormatTextEn.GetLength()));
		_cstrFormatTextEn.ReleaseBuffer();
	}

	va_list vlsLog;
	va_start( vlsLog, cLogFmt );
	_vsnprintf(cLogBuf, MAX_LOG_MSG_LEN, cLogFmt, vlsLog);
	va_end(vlsLog);

	cstrDstInfo = cLogBuf;
	return cstrDstInfo;
}